<?php namespace Concrete\Package\SocialStream\Block\SocialStream;
use \Concrete\Core\Block\BlockController;
use Package;
use BlockType;
use \Concrete\Core\Block\View\BlockView as BlockView;
use Database;
use Core;
defined('C5_EXECUTE') or die("Access Denied.");

	class Controller extends BlockController {
		
		var $pobj;
		
		protected $btTable = 'btSocialStream';
		protected $btDefaultSet = 'social';
		protected $btInterfaceWidth = "420";
		protected $btInterfaceHeight = "380";
		
		public function getBlockTypeDescription() {
			return t("Display a consolidated feed of all your social media activity.");
		}
		public function getBlockTypeName() {
			return t("Social Stream");
		}
		public function registerViewAssets($outputContent = '')
		{
			$this->requireAsset('javascript','lifestream');
		}

		function save($data) { 
			$db = Database::connection();
			//Networks
			$args['bitbucket'] 	= $data['bitbucket'];
			$args['bitly'] 	= $data['bitly'];
			$args['blogger'] 	= $data['blogger'];
			$args['citeulike'] 	= $data['citeulike'];
			$args['dailymotion'] 	= $data['dailymotion'];
			$args['delicious'] 	= $data['delicious'];
			$args['deviantart'] 	= $data['deviantart'];
			$args['dribbble'] 	= $data['dribbble'];
			$args['facebook'] 	= $data['facebook'];
			$args['fancy'] 	= $data['fancy'];
			$args['flickr'] 	= $data['flickr'];
			$args['formspring'] 	= $data['formspring'];
			$args['forrst'] 	= $data['forrst'];
			$args['foursquare'] 	= $data['foursquare'];
			$args['gimmebar'] 	= $data['gimmebar'];
			$args['github'] 	= $data['github'];
			$args['instapaper'] 	= $data['instapaper'];
			$args['lastfm'] 	= $data['lastfm'];
			$args['librarything'] 	= $data['librarything'];
			$args['mlkshk'] 	= $data['mlkshk'];
			$args['pinboard'] 	= $data['pinboard'];
			$args['pocket'] 	= $data['pocket'];
			$args['quora'] 	= $data['quora'];
			$args['reddit'] 	= $data['reddit'];
			$args['rss'] 	= $data['rss'];
			$args['slideshare'] 	= $data['slideshare'];
			$args['snipplr'] 	= $data['snipplr'];
			$args['stackoverflow'] 	= $data['stackoverflow'];
			$args['tumblr'] 	= $data['tumblr'];
			$args['twitter'] 	= $data['twitter'];
			$args['vampirefreaks'] 	= $data['vampirefreaks'];
			$args['vimeo'] 	= $data['vimeo'];
			$args['wikipedia'] 	= $data['wikipedia'];
			$args['wordpress'] 	= $data['wordpress'];
			$args['youtube'] 	= $data['youtube'];
			$args['zotero'] 	= $data['zotero'];
			
			//Options
			$args['postLimit'] 	= is_numeric($data['postLimit']) ? intval($data['postLimit']) : '200';
			$args['bgColor'] = isset($data['bgColor']) ? $data['bgColor'] : '#333333';
			$args['textColor'] = isset($data['textColor']) ? $data['textColor'] : '#d4d4d4';
			$args['linkColor'] = isset($data['linkColor']) ? $data['linkColor'] : '#f6dd97';
			$args['linkHoverColor'] = isset($data['linkHoverColor']) ? $data['linkHoverColor'] : '#fff5d8';
		
			parent::save($args);
		}
		
		
	}
	
?>