<?php defined('C5_EXECUTE') or die("Access Denied.");
$app = \Concrete\Core\Support\Facade\Application::getFacadeApplication();
$getString = $app->make('helper/validation/identifier')->getString(18);
?>

<div class="msv-auto-typing" id="msv-auto-typing-<?= $getString; ?>">
    <div id="typed-strings-<?= $getString; ?>" class="msv-auto-typing-source">
        <?= $strings; ?>
    </div>
<?php
$placeholder = '{t}';

if (!$template) {
    $template = $placeholder;
}

if (stripos($template, $placeholder) !== false) {
echo str_ireplace($placeholder, '<span id="typed-'. $getString .'" class="msv-auto-typing-text"></span>', $template); ?>

<script>
function initTyped<?= $getString; ?>() {
    var typed = new Typed('#typed-<?= $getString; ?>', {
        stringsElement: '#typed-strings-<?= $getString; ?>',
        typeSpeed: <?= $typeSpeed; ?>,
        startDelay: <?= $startDelay; ?>,
        loop: <?= ($loopTyping ? 'true' : 'false'); ?>,
        shuffle: <?= ($shuffle ? 'true' : 'false'); ?>,
        showCursor: <?= ($showCursor ? 'true' : 'false'); ?>,
        <?php if ($fadeOut) { ?>
        fadeOut: true,
        fadeOutDelay: <?= $fadeOutDelay; ?>,
        <?php } else { ?>
        smartBackspace: <?= ($smartBackspace && !$shuffle ? 'true' : 'false'); ?>,
        backSpeed: <?= $backSpeed; ?>,
        backDelay: <?= $backDelay; ?>,
        <?php } ?>
    });
}

if (document.readyState !== "loading") {
    initTyped<?= $getString; ?>();
} else {
    document.addEventListener("DOMContentLoaded", function(){
        initTyped<?= $getString; ?>();
    });
}
</script>
<?php if ($fadeOut) { ?>
<style>
    #msv-auto-typing-<?= $getString; ?> .typed-fade-out {
        transition-duration: <?= $fadeOutSpeed; ?>ms;
        transition-delay: <?= max(0,$fadeOutDelay - $fadeOutSpeed); ?>ms;
    }

</style>
<?php } ?>

<?php } else {
    echo $template;
} ?>

<?php if (!$strings && is_object($c) && $c->isEditMode()) { ?>
    <div class="ccm-edit-mode-disabled-item"><?= t('No typing text entered'); ?></div>
<?php } ?>
</div>
