<?php defined('C5_EXECUTE') or die("Access Denied.");

/**
 * ab_google_maps package for Concrete5
 * Copyright Copyright 2018-2019, Alex Borisov
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * @author Alex Borisov <linuxoidoz@gmail.com>
 * @package Concrete\Package\ab_google_maps
 */
 
use Concrete\Core\Page\Page;

$c = Page::getCurrentPage();
if ($c->isEditMode()) { ?>
	<div class="ccm-edit-mode-disabled-item">
		<div style="padding: 20px 0px"><?php echo t('Google Map display disabled in edit mode.'); ?></div>
	</div>
<?php 
}
elseif ($show_map) { ?>
    <div class="ab-google-maps">
        <div class="ab-google-map" data-jq="<?php echo h($data); ?>" style="height: <?php echo $height; ?>; width: <?php echo $width; ?>;"></div>
    </div>
<?php 
}
else { ?>
    <div class="form-group">
        <div class="alert alert-danger" role="alert">
        <?php echo t('Map cannot be displayed'); ?>
        </div>             
    </div>
<?php 
} 
?>


