/**
 * ab_contact_form package for Concrete5
 * concrete5.org marketplace license
 * Copyright Copyright 2017-2018, Alex Borisov
 *
 * @author Alex Borisov <linuxoidoz@gmail.com>
 * @package Concrete\Package\ab_contact_form
 */

$(function(){
    $('.contact-form').submit(function(e){
        bUID = $(this).find('input[name=bUID]').data("buid");
        popup = $(this).find('input[name=bUID]').data("popup");
        e.preventDefault();
        e.stopPropagation();
        submitContactForm(bUID, popup);
    });

    $('.contact-form-a').on('click', function(e) {
        bUID = $(this).data("buid");
        var form = $('#contact_form'+bUID);
        popup = form.find('input[name=bUID]').data("popup");
        
        if (popup == true) {
            form.removeClass("hidden");
            form[0].reset();
            form.find('.problem').removeClass("problem");
            form.find('[id^="tip-"]').removeClass("hidden");
            form.find('[id^="error-"]').addClass("hidden");
            $('#success'+bUID).empty();
            $('#errors'+bUID).empty();
            if ($('#captcha_img'+bUID).length) {
                $('#captcha_img'+bUID).attr('src', $('#captcha_img'+bUID).attr('src').replace(/([?&]nocache=)(\d+)/, '$1' + ((new Date()).getTime())));
            }
            else if ($('.ccm-captcha-image')[0]) {
                $('.ccm-captcha-image').trigger("click");
            }
            
            e.preventDefault();
            $.magnificPopup.open({
                items: {
                    src: '#contact-form-'+bUID,
                    type: 'inline',
                },
                focus: '#name'+bUID,
                alignTop: false,
                fixedContentPos: 'auto',
                fixedBgPos: true,
                overflowY: 'auto',
                closeBtnInside: true,
                preloader: false,
                midClick: true,
                removalDelay: 300,
                mainClass: 'my-mfp-zoom-in',

                callbacks: {
                    beforeOpen: function() {
                        if($(window).width() < 700) {
                            this.st.focus = false;
                        } else {
                            this.st.focus = '#name'+bUID;
                        }
                    }
                }
            });
        }
    });
    
    $('.contact-form input[type=text], textarea').on('change invalid', function() {
        var textfield = $(this).get(0);
        textfield.setCustomValidity('');
        if (!textfield.validity.valid) {
            textfield.setCustomValidity(js_strings.js_required);  
        }
    });
    
    $('.contact-form input[type=text], textarea').hover(function() {
        $(this).attr('title', js_strings.js_required);
    });
    
    $('.contact-form input[type=text]').on('blur', function(e) {
        switch($(this).data("tag")) {
            case 'name':
                validate_contact_name(e);
                break;
            case 'email':
                validate_contact_email(e);
                break;
            case 'code':
                validate_contact_code(e);
                break;
        } 
    });
    
    $('.contact-form textarea').on('blur', function(e) {
        validate_contact_message(e);
    });
    $('.contact-form textarea').attr('maxlength', '1000'); 
    
});

function submitContactForm(bUID, popup) {
    $('#success'+bUID).empty();
    $('#errors'+bUID).empty();
    
    var post_data = {
    'name': $('#name'+bUID).val(),
    'email': $('#email'+bUID).val(),
    'message': $('#message'+bUID).val(),
    'ccmCaptchaCode': $('#code'+bUID).val(),
    'buid': bUID,
    'g-recaptcha-response': ($('.g-recaptcha')[0]? grecaptcha.getResponse() : null),
    };
    
    $('#spinner_img'+bUID).removeClass("hidden");
    $.ajax({
        dataType: "json",
        type: "post",
        data: post_data,
        url:   $('#contact_form'+bUID).attr('action'),
        success: function(response) {
            $('#error_list'+bUID).empty();
            $('#spinner_img'+bUID).addClass("hidden");
            if (typeof response !== 'undefined' && response.length > 0) {
                if (response[0] == "success") {
                    $('#errors'+bUID).addClass("hidden");
                    $('#success'+bUID).removeClass("hidden");
                    $('#success'+bUID).append('<p>' + js_strings.js_success + '</p>');
                    $('#contact_form'+bUID)[0].reset();
                    if (popup == true) {
                        $('#contact_form'+bUID).addClass("hidden");
                    }
                    $('.ccm-captcha-image').trigger("click");
                    ConcreteAlert.notify({
                        title: js_strings.js_success,
                        message: ""
                    });                    
                }
                else {
                    $('#success'+bUID).addClass("hidden");
                    $('#errors'+bUID).removeClass("hidden");
                    $('#errors'+bUID).append('<p>' + js_strings.js_errors + '</p>');
                    $('#errors'+bUID).append('<ul id="error_list'+bUID+'"></ul>');
                    $.each(response, function(i, v){
                        if (i > 0) {
                            $('#error_list'+bUID).append('<li>' + v + '</li>');
                        }
                    });
                    $('#errors'+bUID).append('<hr />');
                    ConcreteAlert.error({
                        title: js_strings.js_errors,
                        message: js_strings.js_submit_error
                    });                    
                }
            } 
            else {
                $('#success'+bUID).addClass("hidden");
                $('#errors'+bUID).removeClass("hidden");
                $('#errors'+bUID).append('<p>' + js_strings.js_errors + '</p>');
                $('#errors'+bUID).append('<p>' + js_strings.js_response_error + '</p>');
                ConcreteAlert.error({
                    title: js_strings.js_errors,
                    message: js_strings.js_response_error
                });
            }
        },
        error: function(jqXHR, textStatus, errorThrown) {
            $('#spinner_img'+bUID).addClass("hidden");
            $('#success'+bUID).addClass("hidden");
            $('#errors'+bUID).removeClass("hidden");
            $('#errors'+bUID).append('<p>' + js_strings.js_errors + '</p>');
            $('#errors'+bUID).append('<p>' + errorThrown + '</p>');
            ConcreteAlert.error({
                title: js_strings.js_errors,
                message: errorThrown
            });                    
        },
    });
    
    $('#contact_form'+bUID+' input').blur();
    if ($('.g-recaptcha')[0]) {
        grecaptcha.reset();
    };
    
}

function validate_contact_name(e) {
    var el = $('#'+e.target.id);
    var id = e.target.id;
    var v = $('#'+e.target.id).val();
    if (!v || v.length < 2 || v.length > 60) {
        $('#error-'+id).removeClass("hidden");
        $('#tip-'+id).addClass("hidden");
        $(el).addClass("problem");
        return false;
    }
    else {
        $('#error-'+id).addClass("hidden");
        $('#tip-'+id).removeClass("hidden");
        $(el).removeClass("problem");
        return true;
    }
}
    
function validate_contact_email(e) {
    var el = $('#'+e.target.id);
    var id = e.target.id;
    var v = $('#'+e.target.id).val();
    var email = /^([_a-zA-Z0-9-]+)(\.[_a-zA-Z0-9-]+)*@([a-zA-Z0-9-]+)(\.[a-zA-Z0-9-]+)*(\.[a-zA-Z]{2,10})$/;
    if (!email.test(v) || v.length < 8 || v.length > 100) {
        $('#error-'+id).removeClass("hidden");
        $('#tip-'+id).addClass("hidden");
        $(el).addClass("problem");
        return false;
    }
    else {
        $('#error-'+id).addClass("hidden");
        $('#tip-'+id).removeClass("hidden");
        $(el).removeClass("problem");
        return true;
    }
}
    
function validate_contact_message(e) {
        var el = $('#'+e.target.id);
        var id = e.target.id;
        var v = $('#'+e.target.id).val();
        if (!v || v.length < 10 || v.length > 1000) {
            $('#error-'+id).removeClass("hidden");
            $('#tip-'+id).addClass("hidden");
            $(el).addClass("problem");
            return false;
        }
        else {
            $('#error-'+id).addClass("hidden");
            $('#tip-'+id).removeClass("hidden");
            $(el).removeClass("problem");
            return true;
        }
}
    
function validate_contact_code(e) {
        var el = $('#'+e.target.id);
        var id = e.target.id;
        var v = $('#'+e.target.id).val();
        if (!v || v.length < 4 || v.length > 6) {
            $('#error-'+id).removeClass("hidden");
            $('#tip-'+id).addClass("hidden");
            $(el).addClass("problem");
            return false;
        }
        else {
            $('#error-'+id).addClass("hidden");
            $('#tip-'+id).removeClass("hidden");
            $(el).removeClass("problem");
            return true;
        }
}

    

