<?php 
namespace Concrete\Package\Dashboard4concrete5\Controller\SinglePage\Dashboard;

defined('C5_EXECUTE') or die('Access Denied.');

use \Concrete\Core\Page\Controller\DashboardPageController;
use Package;


class Dashboard4concrete5 extends DashboardPageController {

	public function view() {

		// Result array.
		$packages = array();

		// Get installed handles.
		$installedHandles = Package::getInstalledHandles();

		// Loop through installed handles.
		foreach ($installedHandles as $handle) {

			// Get package class.
			$pkg = Package::getClass($handle);

			// Check if it is a 4Concrete5 package.
			if ($pkg && method_exists($pkg, 'is4C5Package')) {

				// Do check (mostly true :P)
				if ($pkg->is4C5Package()) {
					
					// Add this 4C5 package.
					$packages[] = $pkg;
				}
			}
		}

		// Set view variables.
		$this->set('packages', $packages);
	}
}

?>