<?php
namespace Concrete\Package\Sudoku\Block\Sudoku;

use Concrete\Core\Block\BlockController;

class Controller extends BlockController
{
    protected $btTable = 'btSudoku';
    protected $btInterfaceWidth = "400";
    protected $btWrapperClass = 'ccm-ui';
    protected $btInterfaceHeight = "365";
    protected $levels;

    public function getBlockTypeDescription()
    {
        return t('Adding Sudoku game');
    }

    public function getBlockTypeName()
    {
        return t('Sudoku');
    }

    public function add()
    {
        $this->set('defaultLevel', 1);
        $this->set('displayLevelsChoice', 1);
        $this->set('displayNewGameBtn', 1);
        $this->set('displaySolveItBtn', 1);
    }

    public function save($args)
    {
        $args['displayLevelsChoice'] = isset($args['displayLevelsChoice']) ? 1 : 0;
        $args['displayNewGameBtn'] = isset($args['displayNewGameBtn']) ? 1 : 0;
        $args['displaySolveItBtn'] = isset($args['displaySolveItBtn']) ? 1 : 0;

        parent::save($args);
    }

    public function registerViewAssets($outputContent = '')
    {
        $this->requireAsset('sudoku');
    }

    public function view()
    {
        $this->set('uniqueID', $this->app->make('helper/validation/identifier')->getString(18));
    }
}
