<?php defined('C5_EXECUTE') or die("Access Denied.");
$c = Page::getCurrentPage();
if ($c->isEditMode()):
    ?>
    <div class="ccm-edit-mode-disabled-item" style="padding: 40px 0px 40px 0px;">
        <p><?php echo t('Sudoku is disabled in edit mode.'); ?></p>
    </div>
    <?php
else:
    ?>
    <div id="sudoku<?php echo $uniqueID; ?>">
        <div class="container sudoku">
            <div class="row">
                <div class="col-md-10 col-md-push-1 col-xs-12">
                    <div class="numbers">
                        <span data-numbers-val="1">1</span>
                        <span data-numbers-val="2">2</span>
                        <span data-numbers-val="3">3</span>
                        <span data-numbers-val="4">4</span>
                        <span data-numbers-val="5">5</span>
                        <span data-numbers-val="6">6</span>
                        <span data-numbers-val="7">7</span>
                        <span data-numbers-val="8">8</span>
                        <span data-numbers-val="9">9</span>
                        <span data-numbers-val="0">X</span>
                    </div>
                    <div class="board center-block">
                        <div class="sudoku-grid">
                            <div class="solve">
                                <div class="solution">
                                    <span class="close">X</span>
                                    <p><strong><?php echo t('Game completed:'); ?></strong></p>
                                    <p><span class="solve-h"></span> <?php echo t('hours'); ?>, <span class="solve-m"></span> <?php echo t('minutes'); ?>, <span class="solve-s"></span> <?php echo t('seconds'); ?></p>
                                    <div class="buttons text-right">
                                        <button name="ok" class="btn btn-primary"><?php echo t('Ok'); ?></button>
                                    </div>
                                </div>
                            </div>
                            <div class="overlay"></div>
                            <table>
                                <?php
                                $i = $j = 0;
                                while ($i < 9):
                                    echo '<tr>';
                                    while ($j < 9):
                                        echo '<td><div data-cell="x' . "{$i}_{$j}" . '"></div></td>';
                                        ++$j;
                                    endwhile;
                                    $j = 0;
                                    echo '</tr>';
                                    ++$i;
                                endwhile;
                                ?>
                            </table>

                        </div>
                        <div class="row">
                            <div class="col-md-6 text-left">
                                <form name="controls<?php echo $uniqueID; ?>" class="sudoku-difficulty">
                                    <?php if ($displayLevelsChoice):?>
                                        <label for="easy"><?php echo $form->radio('level', 0, $defaultLevel, ['id' => 'easy']); ?><?php echo t('Easy'); ?></label>
                                        <label for="medium"><?php echo $form->radio('level', 1, $defaultLevel, ['id' => 'medium']); ?><?php echo t('Medium'); ?></label>
                                        <label for="hard"><?php echo $form->radio('level', 2, $defaultLevel, ['id' => 'hard']); ?><?php echo t('Hard'); ?></label>
                                    <?php else: ?>
                                        <input type="hidden" name="level" value="<?php echo $defaultLevel; ?>">
                                    <?php endif; ?>
                                </form>
                            </div>

                            <div class="col-md-6 text-right">
                                <?php if ($displayNewGameBtn):?><button name="newGame" class="btn btn-default new-game"><?php echo t('New Game'); ?></button><?php endif; ?>
                                <?php if ($displaySolveItBtn):?><button name="solveGame" class="btn btn-default solve-game"><?php echo t('Solve it'); ?></button><?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script type="text/javascript">
        $(function(){
            (new SudokuInit('<?php echo $uniqueID; ?>')).initAndStart();
        });
    </script>
<?php endif;?>