<?php
defined('C5_EXECUTE') or die("Access Denied.");
$app = \Concrete\Core\Support\Facade\Application::getFacadeApplication();
$editor = $app->make('editor');

$tabs = [
    ['strings' , t('Typed Text'), true],
    ['template', t('Template')],
    ['options' , t('Display Options')],
];
echo $app->make('helper/concrete/ui')->tabs($tabs);
?>


<div id="ccm-tab-content-strings" class="ccm-tab-content">
    <div class="form-group">
        <?= $editor->outputBlockEditModeEditor('strings', $strings);
        ?>
    </div>
    <span class="help-block"><?= t('List the typed text you wish to display on your block as separate lines. Paragraph or heading styling will come from the template, but inline styles and links can be applied to your text here.'); ?></span>
    <span class="help-block"><?= t('To add a pause within typing, add a %s symbol followed by a number of milliseconds, e.g. %s', '^', '^1000'); ?></span>

</div>

<div id="ccm-tab-content-template" class="ccm-tab-content">
    <div class="form-group">

        <?= $editor->outputBlockEditModeEditor('template', $template); ?>
    </div>
    <span class="help-block"><?= t('Configure any additional text to display with your typed text here. Place %s where you wish your typed text to display.', '{t}'); ?></span>

</div>

<div id="ccm-tab-content-options" class="ccm-tab-content">

    <div class="row">
        <div class="col-md-6">
            <div class="form-group">
                <?= $form->label('typeSpeed', t('Typing Speed')); ?>
                <div class="input-group">
                    <?= $form->number('typeSpeed', $typeSpeed, ['min' => '0', 'step' => '1']); ?>
                    <div class="input-group-addon">
                        <?= t('ms'); ?>
                    </div>
                </div>
                <span class="help-block"><?= t('Speed in ms that each character is typed'); ?></span>
            </div>
        </div>

        <div class="col-md-6">
            <div class="form-group">
                <?= $form->label('startDelay', t('Start Delay')); ?>
                <div class="input-group">
                    <?= $form->number('startDelay', $startDelay, ['min' => '0', 'step' => '1']); ?>
                    <div class="input-group-addon">
                        <?= t('ms'); ?>
                    </div>
                </div>
                <span class="help-block"><?= t('Time before typing starts in milliseconds'); ?></span>
            </div>
        </div>
    </div>


    <div class="form-group">
        <label>
            <?= $form->checkbox('loopTyping', 1, $loopTyping); ?>
            <?= t('Loop the typed text'); ?>
        </label>

    </div>

    <div class="form-group">
        <label>
            <?= $form->checkbox('shuffle', 1, $shuffle); ?>
            <?= t('Shuffle typed text'); ?>
        </label>

    </div>

    <div class="form-group">
        <label>
            <?= $form->checkbox('showCursor', 1, $showCursor); ?>
            <?= t('Display the cursor as the text types'); ?>
        </label>

    </div>


    <div class="form-group">
        <?= $form->label('fadeOut', t('Backspacing or Fade Out Effect')); ?>
        <?= $form->select('fadeOut', ['0' => t('Show backspacing'), '1' => t('Fade out text')], $fadeOut); ?>
    </div>


    <div class="<?= ($fadeOut ? 'hidden' : ''); ?>" id="backspaceoptions">
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <?= $form->label('backSpeed', t('Back Speed')); ?>
                    <div class="input-group">
                        <?= $form->number('backSpeed', $backSpeed, ['min' => '0', 'step' => '1']); ?>
                        <div class="input-group-addon">
                            <?= t('ms'); ?>
                        </div>
                    </div>
                    <span class="help-block"><?= t('Backspacing speed in milliseconds'); ?></span>
                </div>
            </div>
            <div class="col-md-6">

                <div class="form-group">
                    <?= $form->label('backDelay', t('Back Delay')); ?>
                    <div class="input-group">
                        <?= $form->number('backDelay', $backDelay, ['min' => '0', 'step' => '1']); ?>
                        <div class="input-group-addon">
                            <?= t('ms'); ?>
                        </div>
                    </div>
                    <span class="help-block"><?= t('Time before backspacing in milliseconds'); ?></span>
                </div>
            </div>
        </div>

        <div class="form-group">
            <label>
                <?= $form->checkbox('smartBackspace', 1, $smartBackspace); ?>
                <?= t('Smart Backspace'); ?>
            </label>
            <span class="help-block"><?= t("Only backspace what doesn't match the next typed text (non-shuffle only)"); ?></span>
        </div>
    </div>

    <div class="<?= (!$fadeOut ? 'hidden' : ''); ?>" id="fadeoutoptions">
        <div class="form-group">
            <?= $form->label('fadeOutDelay', t('Fade Out Time')); ?>
            <div class="input-group">
                <?= $form->number('fadeOutDelay', $fadeOutDelay, ['min' => '0', 'step' => '1']); ?>
                <div class="input-group-addon">
                    <?= t('ms'); ?>
                </div>
            </div>
            <span class="help-block"><?= t('Time before next text starts in milliseconds'); ?></span>
        </div>

        <div class="form-group">
            <?= $form->label('fadeOutSpeed', t('Fade Out Speed')); ?>
            <div class="input-group">
                <?= $form->number('fadeOutSpeed', $fadeOutSpeed, ['min' => '0', 'step' => '1']); ?>
                <div class="input-group-addon">
                    <?= t('ms'); ?>
                </div>
            </div>
            <span class="help-block"><?= t('Time to fade in milliseconds'); ?></span>
        </div>
    </div>


    <script>
        $(document).ready(function () {
            $('#fadeOut').change(function () {
                if ($(this).val() === '1') {
                    $('#backspaceoptions').addClass('hidden');
                    $('#fadeoutoptions').removeClass('hidden');
                } else {
                    $('#backspaceoptions').removeClass('hidden');
                    $('#fadeoutoptions').addClass('hidden');
                }
            })
        });

    </script>
