<?php

namespace Concrete\Package\AbContactForm\Block\AbContactForm;

use Concrete\Core\Block\BlockController;
use Core;
use Package;

/**
 * ab_contact_form package for Concrete5
 * concrete5.org marketplace license
 * Copyright Copyright 2017-2018, Alex Borisov
 *
 * @author Alex Borisov <linuxoidoz@gmail.com>
 * @package Concrete\Package\ab_contact_form
 */
 
class Controller extends BlockController
{
    protected $form_errors = array();
    protected $form_success = array();
    protected $btWrapperClass = 'ccm-ui';
    protected $btInterfaceWidth = "600";
    protected $btInterfaceHeight = "400";
    protected $btTable = 'btAbContactForm';
    protected $btDefaultSet = 'form';

    public $error_name = '';
    public $error_email = '';
    public $error_message = '';
    public $error_code = '';
    public $error_ip = '';
    public $error_domain = '';
    public $error_no_domain = '';
    public $error_token = '';
    public $error_submit = '';
    public $error_num_submit = '';
    public $errors = '';
    public $success = '';
    
    public $name = '';
    public $email = '';
    public $message = '';
    public $proxy_name = '';
    public $proxy_ip = '';
    public $host_name = '';
    public $host_ip = '';
    
    public $wait_time = 60;
    
    public function getBlockTypeDescription() 
    {
        return t("Add contact form with advanced security features");
    }

    public function getBlockTypeName() 
    {
        return t("Advanced Contact Form");
    }

    public function getBlockUID($b = null) {
        if ($b == null) return null;
        $proxyBlock = $b->getProxyBlock();
        return $proxyBlock? $proxyBlock->getBlockID() : $b->bID;
    }
    
    public function on_start() 
    {
        $this->error_name = t('Name must be 2 to 60 characters');
        $this->error_email = t('Email entered incorrectly');
        $this->error_message = t('Message must be 10 to 1000 characters');
        $this->error_code = t('Code from picture entered incorrectly');
        $this->error_ip = t('To prevent spam and abusing contact form, sending messages from IP address %s is prohibited');
        $this->error_domain = t('To prevent spam and abusing contact form, sending messages with domain %s is prohibited');
        $this->error_no_domain = t('Confirmation of validity of domain %s failed');
        $this->error_token = t('Cross-site request forgery form token authentication failed');
        $this->error_submit = t('If you experience difficulties sending your message, please send it by email to %s');
        $this->error_num_submit = t('Your message has just been sent, please wait for some time before sending another message');
        $this->errors = t('Errors found:');
        $this->success = t('Your message has been sent. Thank you.');
        
        $this->set('app', $this->app);
    }

    public function registerViewAssets($outputContent = '')
    {
        if($this->popup) {
            $this->requireAsset('core/lightbox');
        }
        $this->requireAsset('javascript', 'jquery');
        $this->requireAsset('css', 'font-awesome');
    }
    
    public function view() 
    {
        $entry_name = t('Name');
        $entry_name_tip = t('Your name 2-60 characters');
        $entry_email = t('Email');
        $entry_email_tip = t('Your email 8-100 latin characters');
        $entry_message = t('Message');
        $entry_message_tip = t('Your message 10-1000 characters');
        $entry_code = t('Code check');
        $entry_code_tip = t('Code from picture 4-6 characters');
        $entry_code_img = t('Click on picture to reload code');
        
        $this->set('entry_name', $entry_name);
        $this->set('entry_name_tip', $entry_name_tip);
        $this->set('error_name', $this->error_name);
        $this->set('entry_email', $entry_email);
        $this->set('entry_email_tip', $entry_email_tip);
        $this->set('error_email', $this->error_email);
        $this->set('entry_message', $entry_message);
        $this->set('entry_message_tip', $entry_message_tip);
        $this->set('error_message', $this->error_message);
        $this->set('entry_code', $entry_code);
        $this->set('entry_code_tip', $entry_code_tip);
        $this->set('error_code', $this->error_code);
        $this->set('entry_code_img', $entry_code_img);
        
        $this->set('form_title', $this->form_title);
        $this->set('email_to', $this->email_to);
        $this->set('email_subject', $this->email_subject);
        $this->set('form_button_text', $this->form_button_text);
        $this->set('send_button_text', $this->send_button_text);
        $this->set('popup', $this->popup);
        $this->set('show_captcha', $this->show_captcha);
        
        $js_strings = array(
            'js_required' => t('Required'),
            'js_errors' => $this->errors,
            'js_submit_error' => t('Please make sure the form is filled in correctly'),
            'js_response_error' => t('Form response failure, form might not have been sent'),
            'js_success' => $this->success
        );
        $this->set('js_strings', json_encode($js_strings));
    }

    public function action_submit($token = false, $bID = false) 
    {
        if ($this->bID != $bID) {
            return false;
        }
        
        if ($this->app->make('token')->validate('contact_form'.$this->post('buid'), $token)) {
            if ($this->validate_form()) {
                $this->mail_form();
                array_push($this->form_success, "success");
                echo $this->app->make('helper/json')->encode($this->form_success, JSON_UNESCAPED_UNICODE);
            }
            else {
                array_unshift($this->form_errors, "error");
                echo $this->app->make('helper/json')->encode($this->form_errors, JSON_UNESCAPED_UNICODE);
            }
        }
        else {
            $this->form_errors = array();
            array_push($this->form_errors, "error");
            array_push($this->form_errors, $this->error_token);
            echo $this->app->make('helper/json')->encode($this->form_errors, JSON_UNESCAPED_UNICODE);
        }
        exit;
    }
    
    public function validate_form() 
    {
        $txt = $this->app->make('helper/text');
        $this->name = $txt->sanitize($this->post('name'));
        $this->message = strip_tags(html_entity_decode($this->post('message'), ENT_QUOTES, 'UTF-8'));
        $this->email = $txt->sanitize(mb_strtolower(preg_replace('((?:\n|\r|\t|%0A|%0D|%08|%09)+)i' , '', $this->post('email')), 'UTF-8'));
        $domain_name = substr(strrchr($this->email, "@"), 1);
        
        $HTTP_X_FORWARDED_FOR = trim($this->app->request->server->get('HTTP_X_FORWARDED_FOR'));
        $HTTP_VIA = trim($this->app->request->server->get('HTTP_VIA'));
        $REMOTE_ADDR = trim($this->app->request->server->get('REMOTE_ADDR'));
        $REMOTE_HOST = trim($this->app->request->server->get('REMOTE_HOST'));
        
        if (!empty($HTTP_X_FORWARDED_FOR)) {
            $this->proxy_name = $HTTP_VIA;
            $this->proxy_ip = $REMOTE_ADDR;
            $this->host_ip = $HTTP_X_FORWARDED_FOR;
        }
        elseif (!empty($REMOTE_ADDR) and (filter_var($REMOTE_ADDR, FILTER_VALIDATE_IP))) {
            $this->host_ip = $REMOTE_ADDR;
        }
        if (ip2long($this->host_ip) < 1) {
            $this->host_ip = "127.0.0.1";
        }
        $this->host_name = !empty($REMOTE_HOST) ? $REMOTE_HOST : @gethostbyaddr($this->host_ip);
        
        $ip = $this->app->make('ip');
        if ($ip->isBlacklisted()) {
            array_push($this->form_errors, sprintf($this->error_ip, '<b><i>' . $this->host_ip . '</i></b>'));
        }

        if ((mb_strlen($this->name, 'UTF-8') < 2) || (mb_strlen($this->name, 'UTF-8') > 60)) {
            array_push($this->form_errors, $this->error_name);
        }
        
        if ((mb_strlen($this->email, 'UTF-8') < 8) || (mb_strlen($this->email, 'UTF-8') > 100)) {
            array_push($this->form_errors, $this->error_email);
        }
        elseif (!filter_var($this->email, FILTER_VALIDATE_EMAIL)) {
            array_push($this->form_errors, $this->error_email);
        }

        if ($this->blacklisted_domains && in_array($domain_name, explode(',', $this->blacklisted_domains))) {
            array_push($this->form_errors, sprintf($this->error_domain, '<b><i>' . $domain_name . '</i></b>'));
        }
        
        if (!checkdnsrr($domain_name . '.',"MX")) {
            array_push($this->form_errors, sprintf($this->error_no_domain, '<b><i>' . $domain_name . '</i></b>'));
        }

        if ((mb_strlen($this->message, 'UTF-8') < 10) || (mb_strlen($this->message, 'UTF-8') > 1000)) {
            array_push($this->form_errors, $this->error_message);
        }
        
        $db = $this->app->make('database')->connection();
        $q = 'SELECT timestamp FROM btAbContactFormSpam WHERE ip = INET_ATON (?) ORDER BY timestamp';
        $v = [$this->host_ip];
        $r = $db->fetchAssoc($q, $v);
        if ($r && (time() - $r['timestamp']) < $this->wait_time) {
            array_push($this->form_errors, $this->error_num_submit);
        }
        
        if ($this->show_captcha) {
            $captcha = $this->app->make('captcha');
            if (!$captcha->check()) {
                array_push($this->form_errors, $this->error_code);
            }
        }
                
        if (!$this->form_errors) {
            return true;
        }
        elseif ($this->show_submit_error) {
            array_push($this->form_errors, sprintf($this->error_submit, '<b>' . $this->email_to . '</b>'));
            return false;
        }
        else {
            return false;
        }
    }
	    
    public function mail_form() 
    {
        $time = date('H:i:s T O');
        $day = date('l, j F Y');
        
        $subject = html_entity_decode(sprintf($this->email_subject . " %s", BASE_URL), ENT_QUOTES, 'UTF-8');
        
        $txt_message = $subject . "\r\n\r\n";
        $txt_message .= t("Date: ") . $time . " " . $day . "\r\n";
        $txt_message .= t("Host IP: ") . $this->host_ip . "\r\n";
        $txt_message .= t("Host Name: ") . $this->host_name . "\r\n";
        $txt_message .= t("Proxy IP: ") . $this->proxy_ip . "\r\n";
        $txt_message .= t("Proxy Name: ") . $this->proxy_name . "\r\n\r\n";
        $txt_message .= t("Name: ") . $this->name . "\r\n";
        $txt_message .= t("Email: ") . $this->email . "\r\n\r\n";
        $txt_message .= t("Message: ") . "\r\n\r\n";
        $txt_message .= $this->message;
        
        $html_message = "<html><body>";
        $html_message .= "<p style=\"color: #0099ff;\">";
        $html_message .= "<b>" . $subject . "</b><br /><br />";
        $html_message .= "<b>" . t("Date: ") . "</b>" . $time . " " . $day . "<br />";
        $html_message .= "<b>" . t("Host IP: ") . "</b>" . $this->host_ip . "<br />";
        $html_message .= "<b>" . t("Host Name: ") . "</b>" . $this->host_name . "<br />";
        $html_message .= "<b>" . t("Proxy IP: ") . "</b>" . $this->proxy_ip . "<br />";
        $html_message .= "<b>" . t("Proxy Name: ") . "</b>" . $this->proxy_name;
        $html_message .= "</p>";
        $html_message .= "<p>" . t("Name: ") . "</b>" . $this->name . "<br />";
        $html_message .= "<p>" . t("Email: ") . "</b>" . $this->email . "</p>";
        $html_message .= "<p style=\"font-weight: bold;\">" . t("Message: ") . "</p>";
        $html_message .= "<p>" . str_replace("\r","<br />",$this->message) . "</p>";
        $html_message .= "</body></html>";

        $mh = $this->app->make('mail');
        $mh->to($this->email_to);
        $mh->from($this->email, $this->name);
        $mh->replyto($this->email, $this->name);
        $mh->setSubject($subject);
        $mh->setBody($txt_message);
        $mh->setBodyHtml($html_message);
        
        @$mh->sendMail();
        
        $db = $this->app->make('database')->connection();
        $q = 'INSERT INTO btAbContactFormSpam (ip, timestamp) VALUES(INET_ATON (?),?) ON DUPLICATE KEY UPDATE timestamp = ?';
        $v = [$this->host_ip, time(), time()];
        $db->executeQuery($q, $v);
    }
    
    public function add() 
    {
        $this->set('error_submit', $this->error_submit);
    }

    public function edit() 
    {
        $this->set('error_submit', $this->error_submit);
    }

    public function save($args) 
    {
        $args['email_to'] = isset($args['email_to']) ? trim($args['email_to']) : '';
        $args['show_submit_error'] = isset($args['show_submit_error']) ? 1 : 0;
        $args['email_subject'] = isset($args['email_subject']) ? trim($args['email_subject']) : '';
        $args['form_button_text'] = isset($args['form_button_text']) ? trim($args['form_button_text']) : '';
        $args['send_button_text'] = isset($args['send_button_text']) ? trim($args['send_button_text']) : '';
        $args['popup'] = isset($args['popup']) ? 1 : 0;
        $args['show_captcha'] = isset($args['show_captcha']) ? 1 : 0;
        $args['blacklisted_domains'] = isset($args['blacklisted_domains']) ? trim(str_replace(' ', '', $args['blacklisted_domains'])) : '';
        $args['wait_time'] = isset($args['wait_time']) ? $args['wait_time'] : 60;
        parent::save($args);
    }

    public function validate($args)
    {
        $e = $this->app->make('helper/validation/error');
        
        if ((mb_strlen($args['email_to'], 'UTF-8') < 8) || (mb_strlen($args['email_to'], 'UTF-8') > 100) || !filter_var($args['email_to'], FILTER_VALIDATE_EMAIL)) {
            $e->add(t('Email entered incorrectly'));
        }

        return $e;
    }

}
