<?php
namespace Concrete\Package\MsvAutoTyping\Block\MsvAutoTyping;

use Concrete\Core\Block\BlockController;

class Controller extends BlockController
{
    protected $btTable = 'btMsvAutoTyping';
    protected $btInterfaceWidth = "650";
    protected $btWrapperClass = 'ccm-ui';
    protected $btInterfaceHeight = "620";
    protected $btDefaultSet = 'basic';

    public function getBlockTypeDescription()
    {
        return t("Add automatic typing to a page");
    }

    public function getBlockTypeName()
    {
        return t("Auto Typing");
    }

    public function registerViewAssets($outputContent = '')
    {
        $this->requireAsset('javascript', 'msv_typed');
    }

    public function getSearchableContent()
    {
        return  $this->strings . ' ' . $this->template ;
    }

    public function save($args)
    {
        $args['typeSpeed'] = (int)$args['typeSpeed'];
        $args['startDelay'] = (int)$args['startDelay'];
        $args['backDelay'] = (int)$args['backDelay'];
        $args['backSpeed'] = (int)$args['backSpeed'];
        $args['loopTyping'] = isset($args['loopTyping']) ? 1 : 0;
        $args['shuffle'] = isset($args['shuffle']) ? 1 : 0;
        $args['showCursor'] = isset($args['showCursor']) ? 1 : 0;
        $args['smartBackspace'] = isset($args['smartBackspace']) ? 1 : 0;
        $args['fadeOutDelay'] = (int)$args['fadeOutDelay'];
        $args['fadeOutSpeed'] = (int)$args['fadeOutSpeed'];

        parent::save($args);
    }

    public function add()
    {
        $this->set('typeSpeed', 50);
        $this->set('startDelay', 0);
        $this->set('backDelay', 1000);
        $this->set('backSpeed', 20);
        $this->set('loopTyping', 1);
        $this->set('shuffle', 0);
        $this->set('showCursor', 1);
        $this->set('smartBackspace', 1);
        $this->set('fadeOut', 0);
        $this->set('fadeOutDelay', 500);
        $this->set('fadeOutSpeed', 250);
        $this->set('template', '<p>{t}</p>');
    }

}
